dnl gnujdoc_CHECK_SUBDIR(VARIABLE,DIR)
dnl Check if DIR exists, and if DIR exists, then set VARIABLE to DIR,
dnl otherwise set VARIABLE to an empty string "".

AC_DEFUN([gnujdoc_CHECK_SUBDIR],
[dnl
if test -d $srcdir/$2; then
  $1=$2
else
  $1=""
fi
])


dnl gnujdoc_REQUIRE_MAKEINFO([VERSION], [action-if-found], [action-if-not-found])
dnl Check makeinfo version, and if VERSION is greater then exit if-found,
dnl else if-not-found.

AC_DEFUN([gnujdoc_REQUIRE_MAKEINFO],
[dnl
makeinfo_req_ver_major=`echo $1 | sed -n 's/\([[0-9]]*\)\.[[0-9]]*.*$/\1/p'`
makeinfo_req_ver_minor=`echo $1 | sed -n 's/[[0-9]]*\.\([[0-9]]*\).*$/\1/p'`

AC_CHECK_PROG([MAKE_INFO], [makeinfo], [makeinfo], [no])
AC_MSG_CHECKING([makeinfo version])

if test "$MAKE_INFO" = "makeinfo" ; then
  makeinfo_version=`$MAKE_INFO --version | sed -n 's/^.*makeinfo.* \([[0-9]]*\.[[0-9.]]*\).*$/\1/p'`
  makeinfo_ver_major=`echo $makeinfo_version | sed -n 's/\(^[[0-9]]*\)\.[[0-9]]*.*$/\1/p'`
  makeinfo_ver_minor=`echo $makeinfo_version | sed -n 's/^[[0-9]]*\.\([[0-9]]*\).*$/\1/p'`
  if test $makeinfo_ver_major -lt $makeinfo_req_ver_major; then
    AC_MSG_RESULT([makeinfo version is $makeinfo_version, bad major])
    $3
  else
    if test $makeinfo_ver_major -gt $makeinfo_req_ver_major; then
      AC_MSG_RESULT([makeinfo version is $makeinfo_version, ok])
      $2
    else
      if test $makeinfo_ver_minor -ge $makeinfo_req_ver_minor; then
        AC_MSG_RESULT([makeinfo version is $makeinfo_version, ok])
        $2
      else
        AC_MSG_RESULT([makeinfo version is $makeinfo_version, bad minor])
        $3
      fi
    fi
  fi
else
  AC_MSG_RESULT([makeinfo is not installed, bad])
  $3
fi
])
